(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('TaskTypesCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'TaskTypeFactory',
    function ($http, $log, $q, SystemMessaging, TaskType)
    {
        var urlBase = '/wstr/api/task-type';

        function TaskTypesCollection()
        {
            this.isLoaded = false;
            this.taskTypes = [];
        }

        TaskTypesCollection.prototype.load = function()
        {
            var self = this;

            if (this.isLoaded) { return $q.all([]); }

            return $http({
                method : 'GET',
                url : urlBase
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        TaskTypesCollection.prototype.hydrate = function(data)
        {
            for (var i in data)
            {
                var taskTypeData = data[i];
                var taskTypeObject = new TaskType();
                taskTypeObject.hydrate(taskTypeData);
                this.taskTypes.push(taskTypeObject);
            }
            this.isLoaded = true;
        };

        TaskTypesCollection.prototype.deleteTaskType = function(taskType)
        {
            var foundTasks = this.taskTypes.filter(function(element)
            {
                return element.id/1 !== taskType.id/1;
            });
            this.taskTypes = foundTasks;

            return taskType.deleteTask();
        };

        return new TaskTypesCollection();
    }]);
    
})(jQuery, angular, document, window);