(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('TicketReconciliationMapFactory',
        ['$http', '$log', '$q', '$location', 'SystemMessagingFactory', 'AppModelFactory',
         function($http, $log, $q, $location, SystemMessaging, AppModelFactory)
         {

             function TicketReconciliationMap()
             {
                 var self = this;

                 this.exports = ['taskassignment_id', 'organization_id', 'assignmentdate', 'starttime', 'endtime',
                     'guide_id', 'totaltickets', 'noticketscollected'];

                 this.taskassignment_id = this.organization_id = this.assignmentdate = this.starttime = this.endtime =
                     this.guide_id = this.totaltickets = this.noticketscollected = null;

                 this.propertyTypes = {
                     number : ['taskassignment_id', 'organization_id','guide_id', 'totaltickets'],
                     bool   : ['noticketscollected'],
                     time   : ['starttime','endtime']
                 };

                 this.postHydrateCallback = function()
                 {
                     self.updateTimes();
                 };

                 this.updateTimes = function()
                 {
                     var assignmentDate = new Date(self.assignmentdate + " 00:00:00");

                     if (!self.starttime) { self.starttime = new Date(assignmentDate); }
                     if (!self.endtime)   { self.endtime   = new Date(assignmentDate); }

                     self.starttime.setYear(assignmentDate.getFullYear());
                     self.starttime.setMonth(assignmentDate.getMonth());
                     self.starttime.setDate(assignmentDate.getDate());

                     self.endtime.setYear(assignmentDate.getFullYear());
                     self.endtime.setMonth(assignmentDate.getMonth());
                     self.endtime.setDate(assignmentDate.getDate());
                 };


             }

             TicketReconciliationMap.prototype = AppModelFactory.prototype;

             return TicketReconciliationMap;

         }]);
})(jQuery, angular, document, window);
