(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('TicketReconciliationMapCollectionFactory',
    ['$http', '$log', '$q', '$filter', 'SystemMessagingFactory', 'AppModelCollectionFactory', 'TicketReconciliationMapFactory',
    function ($http, $log, $q, $filter, SystemMessaging, AppModelCollectionFactory, TicketReconciliationMap)
    {


        function AvailabilitiesCollection()
        {
            var self = this;

            this.urlBase = '/wstr/api/ticket-reconciliation-map';

            this.collection = [];
            this.startDate = this.endDate = null;

            this.reload = function(startDate, endDate)
            {
                self.collection = [];
                self.startDate = $filter('date')(startDate, 'yyyy-MM-dd');
                self.endDate = $filter('date')(endDate, 'yyyy-MM-dd');
                self.isLoaded = false;
                return self.load();
            };

            this.empty = function()
            {
                this.collection = [];
                this.isLoaded = false;
            };

            this.getLoadUrl = function()
            {
                return self.urlBase +
                    '?startDate=' + self.startDate +
                    '&endDate=' + self.endDate;
            };

            this.hydrateCallback = function(modelData)
            {
                var model = new TicketReconciliationMap();
                model.hydrate(modelData);

                return model;
            };
        }

        AvailabilitiesCollection.prototype = AppModelCollectionFactory.prototype;

        return new AvailabilitiesCollection();
    }]);
    
})(jQuery, angular, document, window);