(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('TourTypesCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'TourTypeFactory',
    function ($http, $log, $q, SystemMessaging, TourType)
    {
        var urlBase = '/wstr/api/tour-type';

        function TourTypesCollection()
        {
            this.isLoaded = false;
            this.tourTypes = [];
        }

        TourTypesCollection.prototype.load = function()
        {
            var self = this;

            if (this.isLoaded) { return $q.all([]); }

            return $http({
                method : 'GET',
                url : urlBase
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        TourTypesCollection.prototype.hydrate = function(data)
        {
            for (var i in data)
            {
                var tourTypeData = data[i];
                var tourTypeObject = new TourType();
                tourTypeObject.hydrate(tourTypeData);
                this.tourTypes.push(tourTypeObject);
            }
            this.isLoaded = true;
        };

        TourTypesCollection.prototype.deleteTourType = function(tourType)
        {
            var foundTours = this.tourTypes.filter(function(element)
            {
                return element.id/1 !== tourType.id/1;
            });
            this.tourTypes = foundTours;

            return tourType.deleteTour();
        };

        return new TourTypesCollection();
    }]);
    
})(jQuery, angular, document, window);