(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('WeekdayAssignmentsCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'WeekdayAssignmentFactory',
    function ($http, $log, $q, SystemMessaging, WeekdayAssignment)
    {
        var urlBase = '/wstr/api/weekday-assignments';

        function WeekdayAssignmentsCollection()
        {
            this.isLoaded = false;
            this.assignments = [];
        }

        WeekdayAssignmentsCollection.prototype.reload = function()
        {
            this.isLoaded = false;
            this.assignments = [];
            return this.load();
        };

        WeekdayAssignmentsCollection.prototype.load = function()
        {
            var self = this;

            if (this.isLoaded) { return $q.all([]); }

            return $http({
                method : 'GET',
                url : urlBase
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        WeekdayAssignmentsCollection.prototype.hydrate = function(data)
        {
            for (var i in data)
            {
                var assignmentData = data[i];
                var assignmentObject = new WeekdayAssignment();
                assignmentObject.hydrate(assignmentData);
                this.assignments.push(assignmentObject);
            }
            this.isLoaded = true;
        };

        WeekdayAssignmentsCollection.prototype.deleteEntry = function(assignment)
        {
            var found = this.assignments.filter(function(element)
            {
                return element.id/1 !== assignment.id/1;
            });
            this.assignments = found;

            return assignment.deleteEntry();
        };

        return new WeekdayAssignmentsCollection();
    }]);
    
})(jQuery, angular, document, window);