(function()
{
    /**
     * get the ISO week number from a date, returns 1-53 (because a year is 52.1429 weeks long)
     *
     * @returns {number}
     */
    Date.prototype.getISOWeek = function()
    {
        var date = new Date(this.getTime());
        date.setHours(0, 0, 0, 0);
        // Thursday in current week decides the year.
        date.setDate(date.getDate() + 3 - (date.getDay() + 6) % 7);
        // January 4 is always in week 1.
        var week1 = new Date(date.getFullYear(), 0, 4);
        // Adjust to Thursday in week 1 and count number of weeks from date to week1.
        return 1 + Math.round(((date.getTime() - week1.getTime()) / 86400000 - 3 + (week1.getDay() + 6) % 7) / 7);
    };

    /**
     * get the four-digit year corresponding to the ISO week of the date
     * @returns {number}
     */
    Date.prototype.getISOWeekYear = function()
    {
        var date = new Date(this.getTime());
        date.setDate(date.getDate() + 3 - (date.getDay() + 6) % 7);
        return date.getFullYear();
    };


    /**
     * Returns a date corresponding to the starting day of the specified ISO week and year
     */
    Date.prototype.getISOWeekStart = function(year, week)
    {
        var simple = new Date(year, 0, 1 + (week - 1) * 7);
        var dow = simple.getDay();
        var ISOweekStart = simple;
        if (dow <= 4)
            ISOweekStart.setDate(simple.getDate() - simple.getDay() + 1);
        else
            ISOweekStart.setDate(simple.getDate() + 8 - simple.getDay());
        return ISOweekStart;
    };
     

})();
